﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：スタンプ注釈の作成

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class AppendAnnotStampCustom
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: AppendAnnotStampCustom in-pdf-file" +
                               " out-pdf-file スタンプ種類 custom-icon-file");
            Console.WriteLine("スタンプ種類");
            Console.WriteLine("0 : カスタム(PDF) 1 : カスタム(Image)");
        }
        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 4)
            {
                printUsage();
                return;
            }
            String stampKind = args[2];
            switch (stampKind)
            {
                case "0":
                case "1":
                    break;
                default:
                    return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                      // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空\n");
                            return;
                        }

                        using (PtlPage page = pages.get(0))
                        using (PtlAnnots annots = page.getAnnots())
                        {
                            switch (stampKind)
                            {
                                case "0":
                                    // 読み込んだPDFを外観とするスタンプ
                                    if (args.Length < 4)
                                    {
                                        Console.WriteLine("スタンプ注釈に使うpdfを指定してください。");
                                        printUsage();
                                        return;
                                    }
                                    addCustomStampAnnotFromPdf(annots, args[3]);
                                    break;
                                case "1":
                                    // 読み込んだ画像を外観とするスタンプ
                                    if (args.Length < 4)
                                    {
                                        Console.WriteLine("スタンプ注釈に使う画像を指定してください。");
                                        printUsage();
                                        return;
                                    }
                                    addCustomStampAnnotFromImage(annots, args[3]);
                                    break;
                            }
                        }
                    }
                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
        public static void addCustomStampAnnotFromPdf(PtlAnnots annots, String pathPdf)
        {
            using (PtlAnnotStamp stampAnnot = new PtlAnnotStamp())
            using (PtlPDFDocument doc_custom = new PtlPDFDocument())
            using (PtlParamInput inputCustom = new PtlParamInput(pathPdf))
            {    // PDFファイル
                stampAnnot.setIconType(PtlAnnotStamp.ICON_TYPE.ICON_CUSTOM);
                stampAnnot.setAnnotFlags(PtlAnnot.ANNOT_FLAGS.FLAG_PRINT);

                // スタンプにするPDFファイルをロードします。
                doc_custom.load(inputCustom);

                using (PtlPages pagesCustomStamp = doc_custom.getPages())
                {
                    // ページコンテナが空かどうか
                    if (pagesCustomStamp.isEmpty())
                    {
                        Console.WriteLine("ページコンテナが空\n");
                        return;
                    }
                    // 追加された画像ページを取得する
                    using (PtlPage pageCustomStamp = pagesCustomStamp.get(0))
                    {
                        // 画像ページを注釈に追加する
                        stampAnnot.setPage(pageCustomStamp);

                        using (PtlSize size = pageCustomStamp.getSize())
                        using (PtlRect rect = new PtlRect(10.0f, 270.0f,
                                                   10.0f + size.getWidth(),
                                                   270.0f + size.getHeight()))
                        {
                            stampAnnot.setRect(rect);
                        }
                    }
                }
                stampAnnot.setIconName("MyIcon");
                annots.append(stampAnnot);
            }
        }
        public static void addCustomStampAnnotFromImage(PtlAnnots annots, String pathImage)
        {
            using (PtlAnnotStamp stampAnnot = new PtlAnnotStamp())
            {

                stampAnnot.setIconType(PtlAnnotStamp.ICON_TYPE.ICON_CUSTOM);
                stampAnnot.setAnnotFlags(PtlAnnot.ANNOT_FLAGS.FLAG_PRINT);
                // 画像描画パラメータ
                // 画像ファイル
                // 画像ページパラメータ の順に取得する
                using (PtlParamDrawImage paramDrawImage = new PtlParamDrawImage())
                using (PtlParamInput inputCustom = new PtlParamInput(pathImage))
                using (PtlParamImagePage paramImagePage = new PtlParamImagePage())
                {
                    // 画像描画パラメータに画像ファイルを設定
                    paramDrawImage.setImageStream(inputCustom);

                    // 画像ページパラメータに画像描画パラメータを設定
                    paramImagePage.setImage(paramDrawImage);

                    // 画像ページのサイズを画像サイズにあわせる
                    paramImagePage.setPaperType(PtlParamImagePage.PAPER_TYPE.PAPER_IMAGE_SIZE);

                    // 画像ページパラメータから作成したページ
                    using (PtlPage pageCustomStamp = new PtlPage(paramImagePage))
                    {
                        // 画像ページを注釈に追加する
                        stampAnnot.setPage(pageCustomStamp);

                        using (PtlSize size = pageCustomStamp.getSize())
                        using (PtlRect rect = new PtlRect(10.0f, 270.0f,
                                                   10.0f + size.getWidth(),
                                                   270.0f + size.getHeight()))
                        {
                            stampAnnot.setRect(rect);
                        }
                    }
                }
                stampAnnot.setIconName("MyIcon");
                annots.append(stampAnnot);
            }
        }

    }
}
